<?php
require_once __DIR__.'/partials.php';
$q = trim($_GET['q'] ?? ''); $posts = [];
if($q!==''){
  $ps = db()->prepare("SELECT p.id,p.title,p.slug,p.summary,p.image,p.published_at,c.name AS cat_name FROM posts p LEFT JOIN categories c ON c.id=p.category_id WHERE p.status='published' AND (p.title LIKE ? OR p.summary LIKE ? OR p.content LIKE ?) ORDER BY p.published_at DESC, p.id DESC LIMIT 50");
  $like = '%'.$q.'%'; $ps->execute([$like,$like,$like]); $posts = $ps->fetchAll(); $ps->closeCursor();
}
header_html('Arama');
?>
<h1 class="text-2xl font-bold mb-4">Arama: "<?= e($q) ?>"</h1>
<?php if($q===''): ?><div class="notice">Aramak için bir ifade yazın.</div>
<?php elseif(!$posts): ?><div class="notice">Sonuç bulunamadı.</div>
<?php else: ?>
<section class="grid sm:grid-cols-2 lg:grid-cols-3 gap-6">
<?php foreach($posts as $p): ?>
  <a class="card" href="article.php?s=<?= e($p['slug']) ?>"><img src="<?= e($p['image'] ?: 'https://picsum.photos/800/400') ?>" alt="<?= e($p['title']) ?>"><div class="body"><div class="badge"><?= e($p['cat_name'] ?? 'Genel') ?></div><h3 class="font-semibold"><?= e($p['title']) ?></h3><p class="text-gray-600 mt-1"><?= e(mb_substr($p['summary'] ?? '',0,100)) ?>...</p></div></a>
<?php endforeach; ?>
</section>
<?php endif; ?>
<?php footer_html(); ?>
