<?php
require_once __DIR__.'/config/helpers.php';
function header_html($title=''){
  $t = $title ? e($title).' - '.e(SITE_NAME) : e(SITE_NAME);
  echo '<!doctype html><html lang="tr"><head>
    <meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
    <title>'.$t.'</title><meta property="og:site_name" content="'.e(SITE_NAME).'">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@3.4.1/dist/tailwind.min.css">
    <link rel="stylesheet" href="'.e(base_url('assets/css/styles.css')).'">
    <script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
    <script src="'.e(base_url('assets/js/main.js')).'" defer></script>
  </head><body class="bg-gray-50 text-gray-800">
  <header class="header">
     <div class="container flex items-center justify-between py-4">
        <a class="text-2xl font-bold text-white" href="'.e(base_url('index.php')).'">'.e(SITE_NAME).'</a>
        <form class="flex items-center gap-2" action="search.php" method="get">
          <input type="text" name="q" placeholder="Ara..." class="border rounded px-3 py-2 text-black">
          <button class="btn btn-primary">Ara</button>
        </form>
     </div>
     <nav class="bg-gray-100 border-t border-b">
       <div class="container flex gap-3 overflow-x-auto py-2">';
  $cats = db()->query("SELECT name, slug FROM categories ORDER BY name ASC")->fetchAll();
  foreach($cats as $c){
    echo '<a class="px-3 py-1 rounded bg-white border hover:bg-gray-50" href="category.php?c='.e($c['slug']).'">'.e($c['name']).'</a>';
  }
  echo   '</div></nav></header><main class="container py-6">';
}
function footer_html(){
  echo '</main><footer class="footer mt-8 bg-white"><div class="container flex items-center justify-between py-6 text-sm text-gray-500">
      <div>&copy; '.date('Y').' '.e(SITE_NAME).'</div><div>PHP 7.4 • PDO • Tailwind</div>
    </div></footer></body></html>';
}
?>
