<?php
require_once __DIR__.'/partials.php';
$slug = trim($_GET['s'] ?? ''); $id = (int)($_GET['id'] ?? 0);
if($slug){
  $ps = db()->prepare("SELECT p.*,c.name AS cat_name,c.slug AS cat_slug FROM posts p LEFT JOIN categories c ON c.id=p.category_id WHERE p.slug=? AND p.status='published' LIMIT 1"); $ps->execute([$slug]);
}else{
  $ps = db()->prepare("SELECT p.*,c.name AS cat_name,c.slug AS cat_slug FROM posts p LEFT JOIN categories c ON c.id=p.category_id WHERE p.id=? AND p.status='published' LIMIT 1"); $ps->execute([$id]);
}
$post = $ps->fetch(); $ps->closeCursor(); if(!$post){ header('HTTP/1.0 404 Not Found'); die('Haber bulunamadı.'); }
header_html($post['title']);
?>
<article class="grid md:grid-cols-3 gap-6">
  <div class="md:col-span-2">
    <img class="w-full rounded-lg" src="<?= e($post['image'] ?: 'https://picsum.photos/1200/600') ?>" alt="<?= e($post['title']) ?>">
    <div class="mt-4">
      <a class="badge" href="category.php?c=<?= e($post['cat_slug']) ?>"><?= e($post['cat_name'] ?? 'Genel') ?></a>
      <h1 class="text-3xl font-bold mt-2"><?= e($post['title']) ?></h1>
      <div class="text-gray-500 text-sm mt-1"><?= e(date('d.m.Y H:i', strtotime($post['published_at'] ?? $post['created_at']))) ?></div>
      <p class="mt-4 text-lg"><?= nl2br(e($post['summary'] ?? '')) ?></p>
      <div class="prose prose-lg max-w-none mt-4"><?= $post['content'] ?></div>
    </div>
  </div>
  <aside>
    <h3 class="font-semibold mb-2">Son Haberler</h3>
    <div class="space-y-3">
      <?php $rs = db()->prepare("SELECT title, slug, image FROM posts WHERE status='published' AND id<>? ORDER BY published_at DESC, id DESC LIMIT 6"); $rs->execute([$post['id']]);
      foreach($rs->fetchAll() as $r){ echo '<a class="flex gap-3 items-center" href="article.php?s='.e($r['slug']).'"><img class="thumb" src="'.e($r['image'] ?: 'https://picsum.photos/120/90').'" alt="'.e($r['title']).'"><div class="text-sm">'.e($r['title']).'</div></a>'; } ?>
    </div>
  </aside>
</article>
<?php footer_html(); ?>
