<?php
require_once __DIR__.'/inc/auth.php';
$exists = db()->query("SELECT COUNT(*) AS c FROM users")->fetch()['c'] ?? 0;
if($exists>0){ die('Kurulum tamam. Güvenlik için bu dosyayı silebilirsiniz.'); }
$err=''; $ok='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  csrf_check();
  $name=trim($_POST['name']??''); $email=trim($_POST['email']??''); $pass=trim($_POST['password']??'');
  if(!$name||!$email||!$pass){ $err='Tüm alanlar zorunlu.'; }
  else{ $hash=password_hash($pass,PASSWORD_BCRYPT); $st=db()->prepare("INSERT INTO users (name,email,password_hash) VALUES (?,?,?)");
    try{ $st->execute([$name,$email,$hash]); $ok='Admin oluşturuldu. <a class="text-blue-600" href="login.php">Giriş</a> yapın.'; } catch(Exception $e){ $err='Hata: '.$e->getMessage(); } }
}
?>
<!doctype html><html lang="tr"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Kurulum - <?= e(SITE_NAME) ?></title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@3.4.1/dist/tailwind.min.css">
<link rel="stylesheet" href="<?= e(base_url('assets/css/styles.css')) ?>">
</head><body class="bg-gray-50 flex items-center justify-center min-h-screen">
<div class="w-full max-w-sm bg-white p-6 rounded-xl shadow">
<h1 class="text-xl font-bold mb-4">İlk Admin Kullanıcı</h1>
<?php if($err): ?><div class="notice mb-3" style="background:#fee2e2;border-color:#fecaca;color:#b91c1c;"><?= e($err) ?></div><?php endif; ?>
<?php if($ok): ?><div class="notice mb-3" style="background:#dcfce7;border-color:#bbf7d0;color:#166534;"><?= $ok ?></div><?php endif; ?>
<form method="post">
  <?= csrf_field() ?>
  <label class="block text-sm mb-1">Ad Soyad</label><input type="text" name="name" required>
  <label class="block text-sm mt-3 mb-1">E-posta</label><input type="email" name="email" required>
  <label class="block text-sm mt-3 mb-1">Şifre</label><input type="password" name="password" required>
  <button class="btn btn-primary w-full mt-4">Oluştur</button>
</form>
</div></body></html>
