<?php
require_once __DIR__.'/auth.php'; $user = current_user();
?>
<!doctype html><html lang="tr"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Admin Panel - <?= e(SITE_NAME) ?></title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@3.4.1/dist/tailwind.min.css">
<link rel="stylesheet" href="<?= e(base_url('assets/css/styles.css')) ?>">
<script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
<script src="<?= e(base_url('assets/js/main.js')) ?>" defer></script>
</head><body class="bg-gray-50">
<header class="bg-slate-900 text-white border-b border-slate-800">
  <div class="container py-4 flex items-center justify-between">
    <div class="text-xl font-bold">Admin Panel</div>
    <div class="text-sm"><?= e($user['name'] ?? 'Admin') ?> | <a class="text-green-400" href="<?= e(base_url('admin/logout.php')) ?>">Çıkış</a></div>
  </div>
</header>
<div class="container py-6 admin-grid">
  <aside class="sidebar">
    <nav class="flex flex-col gap-2">
      <a class="px-3 py-2 rounded border <?= basename($_SERVER['SCRIPT_NAME'])==='index.php'?'active':'' ?>" href="index.php">Gösterge Paneli</a>
      <a class="px-3 py-2 rounded border <?= in_array(basename($_SERVER['SCRIPT_NAME']),['posts.php','post-new.php','post-edit.php'])?'active':'' ?>" href="posts.php">Haberler</a>
      <a class="px-3 py-2 rounded border <?= basename($_SERVER['SCRIPT_NAME'])==='categories.php'?'active':'' ?>" href="categories.php">Kategoriler</a>
    </nav>
  </aside>
  <main>
