<?php
require_once __DIR__.'/inc/auth.php'; require_login();
$err=''; $ok='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  csrf_check();
  if(isset($_POST['add']) && $_POST['add']=='1'){
    $name=trim($_POST['name']??''); if(!$name){ $err='Ad gerekli.'; }
    else{ $slug=slugify($name); $s=db()->prepare("SELECT COUNT(*) c FROM categories WHERE slug=?"); $s->execute([$slug]); $exists=(int)($s->fetch()['c']??0);
      if($exists>0){ $slug.='-'.bin2hex(random_bytes(2)); }
      db()->prepare("INSERT INTO categories (name,slug) VALUES (?,?)")->execute([$name,$slug]); $ok='Kategori eklendi.'; }
  }elseif(isset($_POST['delete']) && $_POST['delete']=='1'){
    $id=(int)($_POST['id']??0); if($id){ db()->prepare("DELETE FROM categories WHERE id=? LIMIT 1")->execute([$id]); $ok='Silindi.'; }
  }
}
$rows = db()->query("SELECT id,name,slug FROM categories ORDER BY name")->fetchAll();
include __DIR__.'/inc/layout.php';
?>
<h1 class="text-2xl font-bold mb-4">Kategoriler</h1>
<?php if($err): ?><div class="notice mb-3" style="background:#fee2e2;border-color:#fecaca;color:#b91c1c;"><?= e($err) ?></div><?php endif; ?>
<?php if($ok): ?><div class="notice mb-3" style="background:#dcfce7;border-color:#bbf7d0;color:#166534;"><?= e($ok) ?></div><?php endif; ?>
<div class="grid md:grid-cols-2 gap-6">
  <div class="card"><div class="body">
    <h2 class="font-semibold mb-3">Yeni Kategori</h2>
    <form method="post" class="space-y-3">
      <?= csrf_field() ?><input type="hidden" name="add" value="1">
      <div><label class="block text-sm mb-1">Ad</label><input type="text" name="name" required></div>
      <button class="btn btn-primary">Ekle</button>
    </form>
  </div></div>
  <div class="card"><div class="body">
    <h2 class="font-semibold mb-3">Mevcut Kategoriler</h2>
    <table class="table"><thead><tr><th>ID</th><th>Ad</th><th>Slug</th><th>İşlem</th></tr></thead><tbody>
    <?php foreach($rows as $r): ?>
      <tr>
        <td><?= e($r['id']) ?></td>
        <td><?= e($r['name']) ?></td>
        <td><?= e($r['slug']) ?></td>
        <td>
          <form method="post" onsubmit="return confirm('Silinsin mi?')">
            <?= csrf_field() ?><input type="hidden" name="delete" value="1"><input type="hidden" name="id" value="<?= e($r['id']) ?>">
            <button class="btn btn-danger">Sil</button>
          </form>
        </td>
      </tr>
    <?php endforeach; ?>
    </tbody></table>
  </div></div>
</div>
<?php include __DIR__.'/inc/footer.php'; ?>
